/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PermissionManager
extends class_4309 {
    public static final String DIRECTORY = "claim_permissions";
    private static final Gson GSON = new GsonBuilder().create();
    public static PermissionManager INSTANCE;
    private Map<class_2960, ClaimPermission> permissions = ImmutableMap.of();
    private List<ClaimPermission> sorted = List.of();
    private final class_7225.class_7874 provider;
    private static final Map<String, String> LEGACY;

    public PermissionManager(class_7225.class_7874 provider) {
        super(GSON, DIRECTORY);
        this.provider = provider;
    }

    @Nullable
    public ClaimPermission get(class_2960 id) {
        return this.permissions.get(id);
    }

    public Collection<class_2960> getIds() {
        return this.permissions.keySet();
    }

    public Collection<ClaimPermission> getAll() {
        return this.sorted;
    }

    public boolean isGlobalPermission(class_2960 id) {
        ClaimPermission perm = this.get(id);
        return perm != null && perm.global;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        data.forEach((res, el) -> {
            try {
                ClaimPermission.Builder props = (ClaimPermission.Builder)ClaimPermission.Builder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)PermissionManager.parseLegacy(res, el)).getOrThrow();
                if (props.verify()) {
                    builder.put(res, (Object)props.build((class_2960)res));
                }
            }
            catch (Exception ex) {
                Flan.LOGGER.error("Couldn't parse claim permission json {} {}", res, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.permissions = builder.build();
        this.sorted = this.permissions.values().stream().sorted().toList();
    }

    private static JsonElement parseLegacy(class_2960 id, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            ArrayList legacy = new ArrayList();
            obj.keySet().forEach(key -> {
                if (LEGACY.containsKey(key)) {
                    legacy.add(key);
                }
            });
            legacy.forEach(key -> {
                JsonElement e = obj.get(key);
                obj.remove(key);
                obj.add(LEGACY.get(key), e);
            });
            if (!legacy.isEmpty()) {
                Flan.LOGGER.warn("Legacy claim_permission {}. Following keys are outdated {}. Please update them! Refer to the documentations", (Object)id, legacy);
            }
            return obj;
        }
        return element;
    }

    static {
        LEGACY = Map.of("requiredMod", "required_mod", "guiItem", "gui_item", "defaultVal", "default_value");
    }
}

